// VERSION: Scilab: 5.4.1 
// OS: windows 7 
//CAPTION: PROGRAM TO COMPUTE LINEAR CONVOLUTION OF TWO SEQUENCES USING DFT BASED APPROACH
clc;
clear;
close;
x=input('Enter the input sequence x(n)=') //x=[1 2 3 1]
m=length(x);
xl=input('Enter the lower index of input sequence=')//0
xh=xl+m-1;
n=xl:1:xh;
subplot(3,1,1);
a=gca();
a.x_location="origin";
a.y_location="origin";
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3('gnn',n,x);
title('Input Sequence x[n]');
xlabel('Samples n');
ylabel('Amplitude');

h=input('Enter the impulse response sequence h(n)=');//h=[1 2 1 -1]
l=length(h);
hl=input('Enter the lower index of impulse response sequence=');//-1
hh=hl+l-1;
g=hl:1:hh;
subplot(3,1,2);
a=gca();
a.x_location="origin";
a.y_location="origin";
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3('gnn',n,h);
title('Impulse Response Sequence h[n]');
xlabel('Samples n');
ylabel('Amplitude');

nx=xl+hl; // range of k
nh=xh+hh;// range of n
p=m+l-1;
x=[x,zeros(1,p-l)];
h=[h,zeros(1,p-m)];

// dft-idft
XK=fft(x,-1); // DFT of x
HK=fft(h,-1); // DFT of h
YK=XK.*HK; // Multiplication of DFT of x and h
yn=fft(YK,1);  // Inverse DFT for obtaining yn
disp('Linear Convolution by DFT-IDFT Method is y(n):'); 
disp(real(yn));
r=nx:nh;
subplot(3,1,3);
a=gca();
a.x_location="origin";
a.y_location="origin";
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3('gnn',r,yn);
title('Output Response Sequence of Linear Convolution by DFT-IDFT Method y[n]');
xlabel('Samples n');
ylabel('Amplitude');

//INPUT:
//Enter the input sequence x(n)=[1 2 3 1]
//Enter the lower index of input sequence=0
//Enter the impulse response sequence h(n)=[1 2 1 -1]
//Enter the lower index of impulse response sequence=-1
 
 //OUTPUT:
 //Linear Convolution by DFT-IDFT Method is y(n):   
 
    //1.    4.    8.    8.    3.  - 2.  - 1. 
